/***************************************************************************
 *
 * Copyright (c) 2013,2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include "stdlib.h"

#include "ilm_calibration.h"
#include "ilm_common.h"

ilmErrorTypes ilm_calibrationApplyFromRawCoordinates(t_ilm_const_string    deviceName,
                                                     t_ilm_const_string    subdivisionName,
                                                     struct ilmCoordinate* expectedLogical1,
                                                     struct ilmCoordinate* expectedLogical2,
                                                     struct ilmCoordinate* expectedLogical3,
                                                     struct ilmCoordinate* sampledRaw1,
                                                     struct ilmCoordinate* sampledRaw2,
                                                     struct ilmCoordinate* sampledRaw3)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationApplyFromRawCoordinates");

    if (deviceName
        && subdivisionName
        && expectedLogical1
        && expectedLogical2
        && expectedLogical3
        && sampledRaw1
        && sampledRaw2
        && sampledRaw3
        && command
        && gIpcModule.appendString(command, deviceName)
        && gIpcModule.appendString(command, subdivisionName)
        && gIpcModule.appendUint(command, expectedLogical1->x)
        && gIpcModule.appendUint(command, expectedLogical1->y)
        && gIpcModule.appendUint(command, expectedLogical2->x)
        && gIpcModule.appendUint(command, expectedLogical2->y)
        && gIpcModule.appendUint(command, expectedLogical3->x)
        && gIpcModule.appendUint(command, expectedLogical3->y)
        && gIpcModule.appendUint(command, sampledRaw1->x)
        && gIpcModule.appendUint(command, sampledRaw1->y)
        && gIpcModule.appendUint(command, sampledRaw2->x)
        && gIpcModule.appendUint(command, sampledRaw2->y)
        && gIpcModule.appendUint(command, sampledRaw3->x)
        && gIpcModule.appendUint(command, sampledRaw3->y)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue))
    {
        returnValue = ILM_SUCCESS;
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}

ilmErrorTypes ilm_calibrationApplyFromLogicalCoordinates (t_ilm_const_string    deviceName,
                                                          t_ilm_const_string    subdivisionName,
                                                          struct ilmCoordinate* expectedLogical1,
                                                          struct ilmCoordinate* expectedLogical2,
                                                          struct ilmCoordinate* expectedLogical3,
                                                          struct ilmCoordinate* sampledLogical1,
                                                          struct ilmCoordinate* sampledLogical2,
                                                          struct ilmCoordinate* sampledLogical3)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationApplyFromLogicalCoordinates");

    if (deviceName
        && subdivisionName
        && expectedLogical1
        && expectedLogical2
        && expectedLogical3
        && sampledLogical1
        && sampledLogical2
        && sampledLogical3
        && command
        && gIpcModule.appendString(command, deviceName)
        && gIpcModule.appendString(command, subdivisionName)
        && gIpcModule.appendUint(command, expectedLogical1->x)
        && gIpcModule.appendUint(command, expectedLogical1->y)
        && gIpcModule.appendUint(command, expectedLogical2->x)
        && gIpcModule.appendUint(command, expectedLogical2->y)
        && gIpcModule.appendUint(command, expectedLogical3->x)
        && gIpcModule.appendUint(command, expectedLogical3->y)
        && gIpcModule.appendUint(command, sampledLogical1->x)
        && gIpcModule.appendUint(command, sampledLogical1->y)
        && gIpcModule.appendUint(command, sampledLogical2->x)
        && gIpcModule.appendUint(command, sampledLogical2->y)
        && gIpcModule.appendUint(command, sampledLogical3->x)
        && gIpcModule.appendUint(command, sampledLogical3->y)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue))
    {
        returnValue = ILM_SUCCESS;
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}

ilmErrorTypes ilm_calibrationStore(t_ilm_const_string deviceName)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationStore");

    if (deviceName
        && command
        && gIpcModule.appendString(command, deviceName)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue))
    {
        returnValue = ILM_SUCCESS;
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}

ilmErrorTypes ilm_calibrationRestore(t_ilm_const_string deviceName)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationRestore");

    if (deviceName
        && command
        && gIpcModule.appendString(command, deviceName)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue))
    {
        returnValue = ILM_SUCCESS;
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}

ilmErrorTypes ilm_calibrationGetParameters(t_ilm_const_string               deviceName,
                                           struct ilmCalibrationParameters* parameters)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationGetParameters");

    if (deviceName
        && parameters
        && gIpcModule.appendString(command, deviceName)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue)
        && gIpcModule.getDouble(response, &parameters->x1)
        && gIpcModule.getDouble(response, &parameters->x2)
        && gIpcModule.getDouble(response, &parameters->x3)
        && gIpcModule.getDouble(response, &parameters->y1)
        && gIpcModule.getDouble(response, &parameters->y2)
        && gIpcModule.getDouble(response, &parameters->y3))
    {
        returnValue = ILM_SUCCESS;
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}

ilmErrorTypes ilm_calibrationApplyParameters(t_ilm_const_string deviceName,
                                             struct ilmCalibrationParameters* parameters)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationApplyParameters");

    if (deviceName
        && parameters
        && gIpcModule.appendString(command, deviceName)
        && gIpcModule.appendDouble(command, parameters->x1)
        && gIpcModule.appendDouble(command, parameters->x2)
        && gIpcModule.appendDouble(command, parameters->x3)
        && gIpcModule.appendDouble(command, parameters->y1)
        && gIpcModule.appendDouble(command, parameters->y2)
        && gIpcModule.appendDouble(command, parameters->y3)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue))
    {
        returnValue = ILM_SUCCESS;
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}

ilmErrorTypes ilm_calibrationStoredCalibrationIsValid(t_ilm_const_string deviceName,
                                                      t_ilm_bool        *valid)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationStoredCalibrationIsValid");

    if (deviceName
        && valid
        && gIpcModule.appendString(command, deviceName)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue)
        && gIpcModule.getBool(response, valid))
    {
        returnValue = ILM_SUCCESS;
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}

ilmErrorTypes ilm_calibrationGetRawCoordinate(t_ilm_const_string    deviceName,
                                              t_ilm_const_string    subdivisionName,
                                              struct ilmCoordinate *logical,
                                              struct ilmCoordinate *raw)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationGetRawCoordinate");

    if (deviceName
        && subdivisionName
        && logical
        && raw
        && gIpcModule.appendString(command, deviceName)
        && gIpcModule.appendString(command, subdivisionName)
        && gIpcModule.appendUint(command, logical->x)
        && gIpcModule.appendUint(command, logical->y)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue)
        && gIpcModule.getUint(response, &raw->x)
        && gIpcModule.getUint(response, &raw->y))
    {
        returnValue = ILM_SUCCESS;
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}

ilmErrorTypes ilm_calibrationGetLogicalCoordinate(t_ilm_const_string    deviceName,
                                                  struct ilmCoordinate *raw,
                                                  t_ilm_string         *subdivisionName,
                                                  struct ilmCoordinate *logical)
{
    ilmErrorTypes returnValue = ILM_FAILED;

    t_ilm_message response = 0;
    t_ilm_message command = gIpcModule.createMessage("CalibrationGetLogicalCoordinate");

    if (deviceName
        && raw
        && subdivisionName
        && logical
        && (*subdivisionName = (t_ilm_string) malloc(sizeof(t_ilm_char) * 512))
        && gIpcModule.appendString(command, deviceName)
        && gIpcModule.appendUint(command, raw->x)
        && gIpcModule.appendUint(command, raw->y)
        && sendAndWaitForResponse(command, &response, RESPONSE_TIMEOUT_IN_MS, &returnValue)
        && gIpcModule.getString(response, *subdivisionName)
        && gIpcModule.getUint(response, &logical->x)
        && gIpcModule.getUint(response, &logical->y))
    {
        returnValue = ILM_SUCCESS;
    }
    else
    {
        if (*subdivisionName != NULL)
        {
            free(*subdivisionName);
            *subdivisionName = NULL;
        }
    }

    gIpcModule.destroyMessage(response);
    gIpcModule.destroyMessage(command);
    return returnValue;
}
